import '@/components/modal/styles.css';

const Modal = (props) => {
    const { isOpen, setIsOpen, title, children } = props;

    return (
        <div id="modal" className={`fixed inset-0 bg-black bg-opacity-50 flex justify-center items-center ${!isOpen && 'hidden'}`}>
            <div className="bg-white rounded-lg p-6 w-1/3 mx-auto relative">
                <button id="closeModal" className={`absolute top-2 right-2 text-gray-600 hover:text-gray-900`} onClick={() => setIsOpen(false)}>
                    &times;
                </button>
                {title && <h3 className="text-lg font-bold text-gray-900">{title}</h3>}
                <div className="mt-2">{children}</div>
            </div>
        </div>

    )
}

export default Modal;

