import { useEffect, useRef } from "react";
import Uppy from "@uppy/core";
import Dashboard from "@uppy/dashboard";
import XhrUpload from "@uppy/xhr-upload";
import "@uppy/core/dist/style.css";
import "@uppy/dashboard/dist/style.css";

const getCookie = () => {
  return decodeURIComponent(document.cookie.split('; ')
    .filter(row => row.startsWith('XSRF-TOKEN='))
    .map(c=>c.split('=')[1])[0])
}

const Uploader = (props) => {
  const uppy = useRef(null);
  const {onUpload} = props

  useEffect(() => {
    if (!uppy.current) {
      uppy.current = new Uppy({
        id: 'uppy',
        autoProceed: false,
        restrictions: {
          maxFileSize: 1024 * 1024 * 100, // 100 MB
          maxNumberOfFiles: 1,
          minNumberOfFiles: 1,
          allowedFileTypes: ['video/*'],
        },
      });

      uppy.current.use(Dashboard, {
        inline: true,
        target: '#uppy-uploader',
        proudlyDisplayPoweredByUppy: false,
        height: 300,
        showProgressDetails: true,
        singleFileFullScreen: false,
      });

      uppy.current.use(XhrUpload, {
        endpoint: process.env.NEXT_PUBLIC_BACKEND_URL + "/api/v1/admin/videos",
        // Called again for every retry too.
        async onBeforeRequest(xhr) {
          // await csrf()
          xhr.setRequestHeader('x-xsrf-token', getCookie())
        },
        allowedMetaFields: null, // send all fields
        withCredentials: true,
      });

      uppy.current.on('upload-success', async (file, response) => {
        console.log('upload-success', file, response);
        try {
          onUpload();

          console.log('Upload successful:');
        } catch (error) {
          console.error('Upload error:', error);
        }
      });

      uppy.current.on("complete", (result) => {
        if (result.failed.length === 0) {
          console.log("Upload successful");
          onUpload();
        } else {
          console.warn("Upload failed");
        }
        console.log("successful files:", result.successful);
        console.log("failed files:", result.failed);
      });
    }

    return () => {
      // return uppy.current.close();
    }
  }, []);

  useEffect(() => {
    if (uppy.current) {
      uppy.current.getPlugin("Dashboard").openModal();
    }
  }, [uppy])


  return <div id="uppy-uploader" />;
};

export default Uploader;
